
Global $h_XBox_DLL, $h_XBox_Hook, $p_XBox_Proc, $h_XBox_Brush, $a_XBox_BttnTxts, $n_XBox_TxtColor, $s_XBox_BGFile, $s_XBox_IconFile

_XBox( _
	"MsgBox", _
	'64|"Modified MsgBox"|"This is a Modified MsgBox ' & @CRLF & 'With Font Color,Icon and Button Changes ' & @CRLF & 'On a New BackGround.."', _
	"Click Done!", _
	0x0000FF, _
	@ScriptDir & "\mac5.bmp", _
	@ScriptDir & "\crapper.ico")

_XBox( _
	"InputBox", _
	'"Modified InputBox"|"This is a Modified InputBox' & @CRLF & 'With Font Color,Icon and Button Changes' & @CRLF & 'On a New BackGround.."', _
	'Confirm|No way!', _
	0xBF0000, _
	@ScriptDir & "\mac5.bmp")

Func _XBoxHookProc($nCode, $wParam, $lParam)
	Local $RET = 0, $hBitmap = 0, $xWnd = 0
	
	If $nCode < 0 Then
		$RET = DllCall($h_XBox_DLL, "int", "CallNextHookEx", _
				"hwnd", $h_XBox_Hook, _
				"int", $nCode, _
				"int", $wParam, _
				"int", $lParam)
		
		Return $RET[0]
	EndIf
	
	Switch $nCode
		Case 5 ;5=HCBT_ACTIVATE
			$hBitmap = DllCall($h_XBox_DLL, "hwnd", "LoadImage", _
					"hwnd", 0, _
					"str", $s_XBox_IconFile, _
					"int", 1, _  ;1=IMAGE_ICON
					"int", 0, _
					"int", 0, _
					"int", 0x0010) ;0x0010=LR_LOADFROMFILE
			
			DllCall($h_XBox_DLL, "int", "SendDlgItemMessage", _
					"hwnd", $wParam, _
					"int", 20, _       ;Icon ID
					"int", 0x0172, _   ;0x0172=STM_SETIMAGE
					"int", 1, _        ;1=IMAGE_ICON
					"int", $hBitmap[0])
			
			For $i = 1 To UBound($a_XBox_BttnTxts)-1
				If $a_XBox_BttnTxts[$i] <> "" Then
						DllCall($h_XBox_DLL, "int", "SetDlgItemText", _
							"hwnd", $wParam, _
							"int", $i, _   ;Button ID
							"str", $a_XBox_BttnTxts[$i])
				EndIf
			Next
		Case 3 ;3=HCBT_CREATEWND
			$xWnd = $wParam
			
			If $p_XBox_Proc = 0 And $xWnd <> 0 Then
				$CMBP = DllCallbackRegister("_XBoxModifyProc", "int", "hwnd;int;int;int")
				$p_XBox_Proc = DllCall($h_XBox_DLL, "int", "SetWindowLong", _
						"hwnd", $xWnd, _
						"int", -4, _     ;-4=GWL_WNDPROC
						"int", DllCallbackGetPtr($CMBP))
			EndIf
		Case 4 ;4=HCBT_DESTROYWND
			If $wParam = $xWnd Then DllCall($h_XBox_DLL, "int", "SetWindowLong", _
					"hwnd", $xWnd, _
					"int", -4, _  ;-4=GWL_WNDPROC
					"int", $p_XBox_Proc[0])
	EndSwitch
	Return
EndFunc

Func _XBox($sBox, $vParams, $vButton_Texts = -1, $nLabel_Color = -1, $sBackground_File = '', $sIcon_File = '')
	Dim $h_XBox_DLL = 0, $h_XBox_Hook = 0, $p_XBox_Proc = 0, $h_XBox_Brush = 0
	Dim $a_XBox_BttnTxts = 0, $n_XBox_TxtColor = 0, $s_XBox_BGFile = '', $s_XBox_IconFile = ''
	
	$h_XBox_DLL = DllOpen("user32.dll")
	
	Local $hProc = DllCallbackRegister("_XBoxHookProc", "int", "int;int;int")
	Local $TID = DllCall("Kernel32.dll", "int", "GetCurrentThreadId")
	
	$h_XBox_Hook = DllCall($h_XBox_DLL, "hwnd", "SetWindowsHookEx", _
			"int", 5, _   ;5=WH_CBT
			"ptr", DllCallbackGetPtr($hProc), _
			"hwnd", 0, _
			"dword", $TID[0])
	
	If $vButton_Texts <> -1 Then
		$a_XBox_BttnTxts = StringSplit($vButton_Texts, "|")
	EndIf
	
	If $nLabel_Color <> -1 Then
		$n_XBox_TxtColor = $nLabel_Color
	EndIf
	
	If $sBackground_File <> "" Then
		$s_XBox_BGFile = $sBackground_File
	EndIf
	
	If $sIcon_File <> "" Then
		$s_XBox_IconFile = $sIcon_File
	EndIf
	
	Local $aParams = StringSplit($vParams, "|")
	$vParams = ""
	
	For $i = 1 To $aParams[0]
		$vParams &= $aParams[$i]
		
		If $i < $aParams[0] Then
			$vParams &= ","
		EndIf
	Next
	
	Local $iRet = Execute($sBox & '(' & $vParams & ')')
	
	DllCall($h_XBox_DLL, "int", "UnhookWindowsHookEx", "hwnd", $h_XBox_Hook[0])
	DllCallbackFree($hProc)
	DllClose($h_XBox_DLL)
	
	Return $iRet
EndFunc

Func _XBoxModifyProc($hWnd, $uMsg, $wParam, $lParam)
	Local $hBitmap = 0, $RET = 0
	
	Switch $uMsg
		Case 272 ;WM_INITDIALOG
			If FileExists($s_XBox_BGFile) Then
				$hBitmap = DllCall($h_XBox_DLL, "hwnd", "LoadImage", _
						"hwnd", 0, _
						"str", $s_XBox_BGFile, _
						"int", 0, _  ;0=IMAGE_BITMAP
						"int", 0, _
						"int", 0, _
						"int", 0x0010) ;0x0010=LR_LOADFROMFILE
				$h_XBox_Brush = DllCall("gdi32.dll", "hwnd", "CreatePatternBrush", "hwnd", $hBitmap[0])
			EndIf
		Case 310, 312 ;310=WM_CTLCOLORDLG,312=WM_CTLCOLORSTATIC
			If $n_XBox_TxtColor <> 0 Then
				DllCall("gdi32.dll", "int", "SetBkMode", "hwnd", $wParam, "int", 1) ;1=TRANSPARENT
				DllCall("gdi32.dll", "int", "SetTextColor", "hwnd", $wParam, "int", _XBoxRGB2BGR($n_XBox_TxtColor))
				
				Return $h_XBox_Brush[0]
			EndIf
	EndSwitch
	
	$RET = DllCall($h_XBox_DLL, "int", "CallWindowProc", "hwnd", $p_XBox_Proc[0], "hwnd", $hWnd, "int", $uMsg, "int", $wParam, "int", $lParam)
	
	Return $RET[0]
EndFunc

Func _XBoxRGB2BGR($iColor)
    If IsInt($iColor) And ($iColor < 2 ^ 24) Then
        Local $iX = BitShift(BitAND($iColor, 0xFF0000), 16)
        Local $iY = BitAND($iColor, 0xFF00)
        Local $iZ = BitShift(BitAND($iColor, 0xFF), -16)
        Return BitOR($iX, $iY, $iZ)
    Else
        Return -1
    EndIf
EndFunc
